# Step 3: Optimizing Backend Performance (Conceptual)

import os

CACHE_FILE = "product_stats_cache.json"
CACHE_EXPIRY = 60  # Cache valid for 60 seconds

def get_cached_stats():
    if os.path.exists(CACHE_FILE):
        with open(CACHE_FILE, 'r') as f:
            data = json.load(f)

        if time.time() - data.get('timestamp', 0) < CACHE_EXPIRY:
            print("CACHE HIT: Using cached stats.")
            return data['stats']
        else:
            print("CACHE EXPIRED: Recalculating.")

    time.sleep(0.5)
    stats = {
        "total_items": len(products_db),
        "avg_price": sum(p['price'] for p in products_db.values()) / len(products_db)
    }

    with open(CACHE_FILE, 'w') as f:
        json.dump({"timestamp": time.time(), "stats": stats}, f)

    return stats


@app.route(f'/{API_VERSION}/products', methods=['GET'])
def get_products():
    limit = request.args.get('limit', default=10, type=int)
    offset = request.args.get('offset', default=0, type=int)

    product_list = list(products_db.values())
    paginated_list = product_list[offset:offset + limit]

    stats = get_cached_stats()

    return jsonify({
        "data": paginated_list,
        "metadata": {
            "total": len(product_list),
            "limit": limit,
            "offset": offset,
            "stats": stats
        }
    })

# if __name__ == '__main__':
#     app.run(debug=True)
