# Step 1: Setup and State Initialization

import streamlit as st
import time

# --- State Initialization Pattern ---
# Check if the keys exist in session_state; if not, initialize them.
if 'page_count' not in st.session_state:
    st.session_state.page_count = 1     # Tracks a conceptual 'page' or step
    st.session_state.user_name = "Guest" # Stores persistent user input
    st.session_state.processed_data = [] # Stores results of an action
    st.session_state.button_clicked = False # Stores status of a button

# --- Streamlit App Layout ---
st.title("Streamlit Session State Demo 💾")
st.markdown("Session State persists inputs and variables across reruns.")

st.header(f"Current State: Page {st.session_state.page_count}")
st.write(f"Hello, **{st.session_state.user_name}**!")
