# Step 4: Conditional Rendering Based on State (Multi-Step Flow)

st.subheader("State-Driven UI Flow")

# Use st.session_state.page_count to determine what to show

if st.session_state.page_count == 1:
    st.info("👋 Welcome! Please enter your name and process the data to continue.")
    # All previous widgets (Input, Process button) are visible here.

elif st.session_state.page_count == 2:
    st.success("🎉 You are now on Step 2.")
    st.write(f"Showing results for **{st.session_state.user_name}**:")
    
    # Only display the processed data and the Reset button from Step 3 here.
    # The initial input and process button are now conceptually hidden 
    # (or placed in an 'if page_count == 1' block in a real app).

    # Display the stored data from the previous step
    for item in st.session_state.processed_data:
        st.markdown(f"- *{item}*")
        
    if st.button("Go Back to Step 1"):
        # Explicitly set the state to return to the first step
        st.session_state.page_count = 1
        st.session_state.button_clicked = False
        st.rerun()

else:
    # Handle unexpected page counts
    st.error("Error: Application is in an invalid state. Please reset.")
