---
# Display name
title: Alex Johnson

# Name pronunciation (optional)
name_pronunciation: ''

# Full name (for SEO)
first_name: Alex
last_name: Johnson

# Pronouns (optional)
pronouns: he/him

# Status emoji
status:
  icon: 🚀

# Is this the primary user of the site?
superuser: true

# Highlight the author in author lists? (true/false)
highlight_name: true

# Role/position/tagline
role: Senior AI Research Scientist

# Organizations/Affiliations to display in Biography blox
organizations:
  - name: Meta AI
    url: https://ai.meta.com/

# Social network links
# Need to use another icon? Simply download the SVG icon to your `assets/media/icons/` folder.
profiles:
  - icon: at-symbol
    url: 'mailto:alex.johnson@meta.com'
    label: E-mail Me
  - icon: brands/x
    url: https://twitter.com/AlexAIResearch
  - icon: brands/github
    url: https://github.com/alexjohnsonai
  - icon: brands/linkedin
    url: https://www.linkedin.com/in/alexjohnsonai/
  - icon: academicons/google-scholar
    url: https://scholar.google.com/citations?user=alexjohnson
  - icon: academicons/orcid
    url: https://orcid.org/0000-0002-1825-0097

interests:
  - Large Language Models
  - Computer Vision
  - Reinforcement Learning
  - AI Ethics

education:
  - area: PhD Computer Science (AI Focus)
    institution: Stanford University
    icon: ""
    date_start: 2015-09-01
    date_end: 2019-06-30
    summary: |
      Thesis on _Scaling Laws for Neural Language Models_. Supervised by Prof. Andrew Ng. Published 5 papers in NeurIPS and ICML, with 2 best paper awards.
    button:
      text: 'Read Thesis'
      url: 'https://example.com/thesis.pdf'
  - area: MS Computer Science
    institution: Carnegie Mellon University
    icon: ""
    date_start: 2013-09-01
    date_end: 2015-05-31
    summary: |
      GPA: 4.0/4.0

      Specialized in machine learning and robotics.
  - area: BS Computer Science
    institution: MIT
    icon: ""
    date_start: 2009-09-01
    date_end: 2013-05-31
    summary: |
      GPA: 3.9/4.0

      Minored in Mathematics. President of AI Club.

work:
  - position: Senior AI Research Scientist
    company_name: Meta AI
    company_url: 'https://ai.meta.com/'
    icon: ''
    date_start: 2020-01-01
    date_end: ''
    summary: |2-
      Leading research on multimodal AI systems. Contributed to Llama 2 and other open-source models. 50+ citations in 3 years.
  - position: AI Research Intern
    company_name: OpenAI
    company_url: 'https://openai.com/'
    icon: ''
    date_start: 2019-06-01
    date_end: 2019-12-31
    summary: |
      Worked on GPT-3 scaling. Co-authored paper on prompt engineering.

# Skills
# Add your own SVG icons to `assets/media/icons/`
skills:
  - name: Technical Skills
    items:
      - name: Python & PyTorch
        description: ''
        percent: 95
        icon: code-bracket
      - name: Machine Learning
        description: ''
        percent: 100
        icon: chart-bar
      - name: Cloud Computing (AWS/GCP)
        description: ''
        percent: 85
        icon: cloud
  - name: Hobbies
    color: '#eeac02'
    color_border: '#f0bf23'
    items:
      - name: Hiking in the Rockies
        description: ''
        percent: 80
        icon: person-simple-walk
      - name: Building Custom PCs
        description: ''
        percent: 90
        icon: cpu-chip
      - name: Sci-Fi Reading
        description: ''
        percent: 70
        icon: book-open

languages:
  - name: English
    percent: 100
  - name: Spanish
    percent: 50

# Awards.
#   Add/remove as many awards below as you like.
#   Only `title`, `awarder`, and `date` are required.
#   Begin multi-line `summary` with YAML's `|` or `|2-` multi-line prefix and indent 2 spaces below.
awards:
  - title: Best Paper Award
    url: https://neurips.cc/
    date: '2022-12-01'
    awarder: NeurIPS
    icon: hero/trophy
    summary: |
      Awarded for groundbreaking work on efficient training of large models.
  - title: AI Innovation Grant
    url: https://www.nsf.gov/
    date: '2021-06-15'
    awarder: National Science Foundation
    icon: hero/currency-dollar
    summary: |
      $500,000 grant for research in ethical AI development.
  - title: Outstanding PhD Thesis
    url: https://www.stanford.edu/
    date: '2019-06-30'
    awarder: Stanford University
    icon: hero/academic-cap
    summary: |
      Recognized for contributions to scaling laws in deep learning.
---

Alex Johnson is a Senior AI Research Scientist at Meta AI, where he leads groundbreaking work on large language models and multimodal systems. His research has been published in top conferences like NeurIPS and ICML, with over 10,000 citations. Alex is passionate about pushing the boundaries of AI while ensuring ethical development. Outside of work, he enjoys hiking in the Rockies, building custom PCs, and mentoring the next generation of AI talent.
